#!/bin/bash
#set -v

SYSDIR=/sys/kernel/config/usb_gadget

if [[ $# -ne 1 ]] 
then 
	echo "usage $0 [gadget subdir]"
	exit 1
fi 

DEVDIR=$SYSDIR/$1

if [[ ! -d $DEVDIR ]]
then
	echo "$DEVDIR does not exist"
	exit 1
fi

echo '' > $DEVDIR/UDC

echo "Removing os_desc"
for str in $DEVDIR/os_desc/*; do
	[ -d $str ] && rm $str
done

echo "Removing strings from configurations"
for dir in $DEVDIR/configs/*/strings/*; do
	[ -d $dir ] && rmdir $dir
done

echo "Removing functions from configurations"
for func in $DEVDIR/configs/*.*/*.*; do
	[ -e $func ] && rm $func
done

echo "Removing configurations"
for conf in $DEVDIR/configs/*; do
	[ -d $conf ] && rmdir $conf
done

echo "Removing functions"
for func in $DEVDIR/functions/*.*; do
	[ -d $func ] && rmdir $func
done

echo "Removing strings"
for str in $DEVDIR/strings/*; do
	[ -d $str ] && rmdir $str
done

echo "Removing gadget"
rmdir $DEVDIR
