#!/bin/bash

mounts=$(cat /proc/mounts)

for file in /media/*; do
    if [[ $file == "/media/internal" ]]; then
        continue
    fi

    if [[ $mounts == *"$file"* ]]; then
        echo "$file present in mounts"
    else
        echo "$file not present in mounts"

        lockfile=$file/.udevil-mount-point
        echo "check for $lockfile"
        if [ -e $lockfile ]; then
            echo "removing dead mount point $lockfile.."
            rm $lockfile
            rmdir $file
        else
            echo "no lockfile, skip dir"
        fi
    fi
done
