#!/bin/sh
#set -e 
set -v

# USB Audio configuration:
AUDIO_IN_CHANNEL_MASK=0xFF
AUDIO_OUT_CHANNEL_MASK=0x3FF
AUDIO_SAMPLE_RATES=48000
AUDIO_SAMPLE_SIZE=3

# USB MIDI configuration
MIDI_ID="MIDI"

# Load libcomposite
modprobe libcomposite
 
# Create a gadget called usb-gadgets
cd /sys/kernel/config/usb_gadget/
mkdir -p usb-gadgets
cd usb-gadgets
 
# Configure our gadget details
echo 0x1d6b > idVendor # Linux Foundation
echo 0x0104 > idProduct # Multifunction Composite Gadget
echo 0x0103 > bcdDevice # v1.0.3
echo 0x0320 > bcdUSB # USB2
echo 0 > bDeviceClass # For midi and RNDIS simulatinously

mkdir -p strings/0x409
echo "0123456789abcdef" > strings/0x409/serialnumber
echo "Tasty Chips Electronics" > strings/0x409/manufacturer
echo "GR-MEGA" > strings/0x409/product

mkdir -p configs/c.1/strings/0x409

echo "CDC" > configs/c.1/strings/0x409/configuration
echo 250 > configs/c.1/MaxPower
echo 0x80 > configs/c.1/bmAttributes

# remove any previously loaded devices.
echo "" > /sys/kernel/config/usb_gadget/usb-gadgets/UDC #unloads all previous usb devices
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/configs/c.1/uac2.usb0 #deletes audio usb config
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/configs/c.1/midi.usb0 #deletes midi usb config
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/configs/c.1/ecm.usb0 #deletes ethernet ECM usb config
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/configs/c.2/rndis.usb0 #deletes ethernet RNDIS usb config
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/configs/c.2/uac2.usb0 #deletes audio usb config
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/configs/c.2/midi.usb0 #deletes midi usb config

rmdir /sys/kernel/config/usb_gadget/usb-gadgets/functions/ecm.usb0 #deletes ethernet ECM usb config
rmdir /sys/kernel/config/usb_gadget/usb-gadgets/functions/rndis.usb0 #deletes ethernet RNDIS usb config
rmdir /sys/kernel/config/usb_gadget/usb-gadgets/functions/uac2.usb0 #deletes audio usb config
rmdir /sys/kernel/config/usb_gadget/usb-gadgets/functions/midi.usb0 #deletes midi usb config
rm -f /sys/kernel/config/usb_gadget/usb-gadgets/os_desc/c.2 #deletes ethernet RNDIS usb config

# removes all loaded modules that are being used.
modprobe -r usb_f_midi
modprobe -r usb_f_uac2
modprobe -r usb_f_rndis
modprobe -r usb_f_ecm

#
# ethernet gadget
#

mkdir -p functions/ecm.usb0

# calculate MAC addresses
#SERIAL=`cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2` # Pi's serial number
#padded='00000000000000'$SERIAL
#for i in -10 -8 -6 -4 -2; do
#    basemac=$basemac':'${padded: $i:2}
#done
#hostmac=$HOSTPREFIX$basemac
#devmac=$DEVICEPREFIX$basemac
#echo $hostmac > functions/ecm.usb0/host_addr
#echo $devmac > functions/ecm.usb0/dev_addr

HOST="32:70:05:18:ff:7a" # "HostPC"
SELF="32:70:05:18:ff:7b" # "Ethernet Gadget"
echo $HOST > functions/ecm.usb0/host_addr
echo $SELF > functions/ecm.usb0/dev_addr
ln -s functions/ecm.usb0 configs/c.1/

#
# RNDIS
#

mkdir -p configs/c.2
echo 0x80 > configs/c.2/bmAttributes
echo 0x250 > configs/c.2/MaxPower
mkdir -p configs/c.2/strings/0x409
echo "RNDIS" > configs/c.2/strings/0x409/configuration
 
echo "1" > os_desc/use
echo "0xcd" > os_desc/b_vendor_code
echo "MSFT100" > os_desc/qw_sign
 
mkdir -p functions/rndis.usb0
HOST_R="00:dc:c8:f7:75:16"
SELF_R="00:dd:dc:eb:6d:a2"
echo $HOST_R > functions/rndis.usb0/dev_addr
echo $SELF_R > functions/rndis.usb0/host_addr
echo "RNDIS" >   functions/rndis.usb0/os_desc/interface.rndis/compatible_id
echo "5162001" > functions/rndis.usb0/os_desc/interface.rndis/sub_compatible_id
 
ln -s functions/rndis.usb0 configs/c.2
ln -s configs/c.2 os_desc

#
# audio gadget
#

# attributes from: https://www.kernel.org/doc/Documentation/ABI/testing/configfs-usb-gadget-uac2
mkdir -p functions/uac2.usb0
echo $AUDIO_IN_CHANNEL_MASK > functions/uac2.usb0/c_chmask
echo $AUDIO_SAMPLE_RATES > functions/uac2.usb0/c_srate
echo $AUDIO_SAMPLE_SIZE > functions/uac2.usb0/c_ssize
echo $AUDIO_OUT_CHANNEL_MASK > functions/uac2.usb0/p_chmask
echo $AUDIO_SAMPLE_RATES > functions/uac2.usb0/p_srate
echo $AUDIO_SAMPLE_SIZE > functions/uac2.usb0/p_ssize
ln -s functions/uac2.usb0 configs/c.2/
ln -s functions/uac2.usb0 configs/c.1/

udevadm settle -t 5 || :
ls /sys/class/udc > UDC  # Rebind after all configs

