#!/bin/sh
#set -e 

# USB MIDI configuration
MIDI_ID="MIDI"

# Load libcomposite
modprobe libcomposite
 
# remove any previously loaded devices.
/bin/bash /root/remove_gadget.sh usb-gadgets/

# Create a gadget called usb-gadgets
cd /sys/kernel/config/usb_gadget/
mkdir -p usb-gadgets
cd usb-gadgets
 
# Configure our gadget details
echo 0x1d6b > idVendor # Linux Foundation
echo 0x0104 > idProduct # Multifunction Composite Gadget
echo 0x0103 > bcdDevice # v1.0.3
echo 0x0200 > bcdUSB # USB2
echo 0 > bDeviceClass # composite

mkdir -p strings/0x409
echo "0123456789abcdef" > strings/0x409/serialnumber
echo "Tasty Chips Electronics" > strings/0x409/manufacturer
echo "GR-MEGA" > strings/0x409/product

mkdir -p configs/c.1/strings/0x409
echo "NCM+MIDI" > configs/c.1/strings/0x409/configuration

echo "CDC" > configs/c.1/strings/0x409/configuration
echo 250 > configs/c.1/MaxPower
echo 0x80 > configs/c.1/bmAttributes

#
# NCM ethernet gadget
#

mkdir -p functions/ncm.usb0
HOST="32:70:05:18:ff:7a" # "HostPC"
SELF="32:70:05:18:ff:7b" # "Ethernet Gadget"
echo $HOST > functions/ncm.usb0/host_addr
echo $SELF > functions/ncm.usb0/dev_addr
ln -s functions/ncm.usb0 configs/c.1/

#
# MIDI gadget
#

# attributes from: https://www.kernel.org/doc/Documentation/ABI/testing/configfs-usb-gadget-midi
mkdir -p functions/midi.usb0
echo $MIDI_ID > functions/midi.usb0/id
ln -s functions/midi.usb0 configs/c.1/
#echo 2 > configs/c.1/MaxPower
echo 0xC0 > configs/c.1/bmAttributes

udevadm settle -t 5 || :
ls /sys/class/udc > UDC  # Rebind after all configs

if cat /sys/firmware/devicetree/base/model | grep -q "Compute Module 5"; then
    nmcli connection up usb0
    sleep 3
    service dnsmasq restart
fi
