#!/bin/sh
 
# USB Audio configuration:
AUDIO_IN_CHANNEL_MASK=0xFF
AUDIO_OUT_CHANNEL_MASK=0x3FF
AUDIO_SAMPLE_RATES=48000
AUDIO_SAMPLE_SIZE=3

# USB MIDI configuration
MIDI_ID="MIDI"

# Load libcomposite
modprobe libcomposite
 
# Create a gadget called usb-gadgets
cd /sys/kernel/config/usb_gadget/
mkdir -p usb-gadgets
cd usb-gadgets
 
# Configure our gadget details
echo 0x1d6b > idVendor # Linux Foundation
echo 0x0104 > idProduct # Multifunction Composite Gadget
echo 0x0100 > bcdDevice # v1.0.0
echo 0x0200 > bcdUSB # USB2
mkdir -p strings/0x409
echo "0123456789abcdef" > strings/0x409/serialnumber
echo "Tasty Chips Electronics" > strings/0x409/manufacturer
echo "GR-MEGA" > strings/0x409/product

mkdir -p configs/c.1/strings/0x409

#
# UAC2 (audio) gadget
#

# attributes from: https://www.kernel.org/doc/Documentation/ABI/testing/configfs-usb-gadget-uac2
mkdir -p functions/uac2.usb0
echo $AUDIO_IN_CHANNEL_MASK > functions/uac2.usb0/c_chmask
echo $AUDIO_SAMPLE_RATES > functions/uac2.usb0/c_srate
echo $AUDIO_SAMPLE_SIZE > functions/uac2.usb0/c_ssize
echo $AUDIO_OUT_CHANNEL_MASK > functions/uac2.usb0/p_chmask
echo $AUDIO_SAMPLE_RATES > functions/uac2.usb0/p_srate
echo $AUDIO_SAMPLE_SIZE > functions/uac2.usb0/p_ssize
ln -s functions/uac2.usb0 configs/c.1/

#
# MIDI gadget
#

# attributes from: https://www.kernel.org/doc/Documentation/ABI/testing/configfs-usb-gadget-midi
mkdir -p functions/midi.usb0
echo $MIDI_ID > functions/midi.usb0/id
ln -s functions/midi.usb0 configs/c.1/

# 2 whole milliamps
echo 2 > configs/c.1/MaxPower
# self powered
echo 0xC0 > configs/c.1/bmAttributes

#
# ethernet gadget
#

mkdir -p functions/ecm.usb0

# calculate MAC addresses
#SERIAL=`cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2` # Pi's serial number
#padded='00000000000000'$SERIAL
#for i in -10 -8 -6 -4 -2; do
#    basemac=$basemac':'${padded: $i:2}
#done
#hostmac=$HOSTPREFIX$basemac
#devmac=$DEVICEPREFIX$basemac
#echo $hostmac > functions/ecm.usb0/host_addr
#echo $devmac > functions/ecm.usb0/dev_addr

HOST="32:70:05:18:ff:7a" # "HostPC"
SELF="32:70:05:18:ff:7b" # "Ethernet Gadget"
echo $HOST > functions/ecm.usb0/host_addr
echo $SELF > functions/ecm.usb0/dev_addr

ln -s functions/ecm.usb0 configs/c.1/

# End functions
ls /sys/class/udc > UDC
