#!/bin/sh
#set -e
#set -v

# USB Audio configuration:
AUDIO_IN_CHANNEL_MASK=0xFF
AUDIO_OUT_CHANNEL_MASK=0x3FF
AUDIO_SAMPLE_RATES=48000
AUDIO_SAMPLE_SIZE=2

# Load libcomposite
modprobe libcomposite

# remove any previously loaded devices.
/bin/bash /root/remove_gadget.sh usb-gadgets/

# Create a gadget called usb-gadgets
cd /sys/kernel/config/usb_gadget/
mkdir -p usb-gadgets
cd usb-gadgets

# Configure our gadget details
echo 0x1d6b > idVendor # Linux Foundation
echo 0x0104 > idProduct # Multifunction Composite Gadget
echo 0x0103 > bcdDevice # v1.0.3
echo 0x0200 > bcdUSB # USB2
echo 0 > bDeviceClass # composite

mkdir -p strings/0x409
echo "0123456789abcdef" > strings/0x409/serialnumber
echo "Tasty Chips Electronics" > strings/0x409/manufacturer
echo "GR-MEGA" > strings/0x409/product

mkdir -p configs/c.1/strings/0x409

echo "CDC" > configs/c.1/strings/0x409/configuration
echo 250 > configs/c.1/MaxPower
echo 0x80 > configs/c.1/bmAttributes

#
# audio gadget
#

# attributes from: https://www.kernel.org/doc/Documentation/ABI/testing/configfs-usb-gadget-uac2
mkdir -p functions/uac2.usb0
echo $AUDIO_IN_CHANNEL_MASK > functions/uac2.usb0/c_chmask
echo $AUDIO_SAMPLE_RATES > functions/uac2.usb0/c_srate
echo $AUDIO_SAMPLE_SIZE > functions/uac2.usb0/c_ssize
echo $AUDIO_OUT_CHANNEL_MASK > functions/uac2.usb0/p_chmask
echo $AUDIO_SAMPLE_RATES > functions/uac2.usb0/p_srate
echo $AUDIO_SAMPLE_SIZE > functions/uac2.usb0/p_ssize
ln -s functions/uac2.usb0 configs/c.1/

udevadm settle -t 5 || :
ls /sys/class/udc > UDC  # Rebind after all configs
